---
generated_at: 2026-01-23 21:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-Scroll To Top設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_arrowup.asp` - スクロールトップ設定画面メイン処理
- E-02: `asp/includes/customer.asp` - cls_customerクラス定義（18行目、219行目、464行目、1612-1634行目）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.93のマッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | スクロールトップ設定はbs_arrowup.aspで実装されている | E-01 | ○ |
| C-02 | sArrowUPはcustomerオブジェクトのプロパティ | E-02 (18行目) | ○ |
| C-03 | FileSystemObjectでarrowsディレクトリをスキャン | E-01 (36-38行目) | ○ |
| C-04 | server.mappath()でディレクトリパスを取得 | E-01 (38行目) | ○ |
| C-05 | 各ファイルに対してラジオボタンが生成される | E-01 (40-47行目) | ○ |
| C-06 | sArrowUPが空の場合は"No arrow"が選択される | E-01 (28行目) | ○ |
| C-07 | customer.save()で設定が保存される | E-01 (12行目) | ○ |
| C-08 | 保存後にfbMessage=fb_saveOKでリダイレクトされる | E-01 (13行目) | ○ |
| C-09 | getArrowJS関数でjQueryスクロールイベントが生成される | E-02 (1612-1621行目) | ○ |
| C-10 | スクロール位置220px以上でボタン表示 | E-02 (1616行目: offset = 220) | ○ |
| C-11 | スクロールアニメーションは500msで実行 | E-02 (1616行目: duration = 500) | ○ |
| C-12 | getArrowCSS関数でposition:fixedスタイルが生成される | E-02 (1629行目) | ○ |
| C-13 | tblCustomerテーブルに設定が保存される | E-02 (464行目) | ○ |
| C-14 | 画面No.93が矢印アップ設定に対応 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルなUI設定機能

## 6) レビュアーチェックリスト（最小）
- [ ] fixedImages/arrowsディレクトリに画像が存在することを確認
- [ ] フロントエンドでスクロールボタンが正しく表示されることを確認
- [ ] スムーズスクロールアニメーションが動作することを確認
